//*****************************************************************************
//*****************************************************************************
//  FILENAME: I2CHW.h
//   Version: 1.90, Updated on 2011/6/28 at 6:9:30
//  Generated by PSoC Designer 5.1.2306
//
//  DESCRIPTION: I2Cs User Module C Language interface file
//-----------------------------------------------------------------------------
//  Copyright (c) Cypress Semiconductor 2011. All Rights Reserved.
//*****************************************************************************
//*****************************************************************************

#include <m8c.h>

#ifndef I2CHW_ADDR_REG_PRESENT
#define I2CHW_ADDR_REG_PRESENT               0                       //CY8C28X45 have 1 always while all other have 0
#endif
#define I2CHW_AUTO_ADDR_CHECK                0                       //CY8C28X45 may have this 0 or 1 while all other have 0

/* Create pragmas to support proper argument and return value passing */
#pragma fastcall16  I2CHW_Start
#pragma fastcall16  I2CHW_DisableInt
#pragma fastcall16  I2CHW_ResumeInt
#pragma fastcall16  I2CHW_EnableInt
#pragma fastcall16  I2CHW_ClearInt
#pragma fastcall16  I2CHW_Stop
#ifdef I2CHW_SLAVE_INCLUDE
#pragma fastcall16  I2CHW_EnableSlave
#pragma fastcall16  I2CHW_DisableSlave
#endif
#ifdef I2CHW_MSTR_INCLUDE
#pragma fastcall16  I2CHW_EnableMstr
#pragma fastcall16  I2CHW_DisableMstr
#endif
#pragma fastcall16  I2CHW_InitWrite
#pragma fastcall16  I2CHW_InitRamRead
#pragma fastcall16  I2CHW_InitFlashRead
#pragma fastcall16  I2CHW_bReadI2CStatus
#pragma fastcall16  I2CHW_ClrRdStatus
#pragma fastcall16  I2CHW_ClrWrStatus

//-------------------------------------------------
// pragma register definitions.
//-------------------------------------------------
#pragma ioport  I2CHW_CFG:  0x0d6                               // I2C Status and Control Register
BYTE            I2CHW_CFG;

#define  I2C_BUSERRIE    0x20
#define  I2C_STOPIE      0x10
#define  I2C_CLKR1       0x08
#define  I2C_CLKR0       0x04
#define  I2C_M_EN        0x02
#define  I2C_S_EN        0x01

#pragma ioport  I2CHW_SCR:  0x0d7                               // I2C Status and Control Register
BYTE            I2CHW_SCR;

#define  I2CM_BUSERR     0x80
#define  I2CM_LOSTARB    0x40
#define  I2C_STOP_ST     0x20
#define  I2C_ACKOUT      0x10
#define  I2C_ADDRIN      0x08
#define  I2C_TX          0x04 //compliment is RX
#define  I2C_LST_BIT     0x02
#define  I2C_BYTE_COMPL  0x01

#pragma ioport  I2CHW_DR:   0x0d8                               // I2C Status and Control Register
BYTE            I2CHW_DR;

#pragma ioport  I2CHW_MSCR: 0x0d9                               // I2C Status and Control Register
BYTE            I2CHW_MSCR;

#define  I2CM_BUSBUSY    0x08
#define  I2CM_MASTEROP   0x04
#define  I2CM_RESTRT     0x02
#define  I2CM_SNDSTRT    0x01

#if (I2CHW_ADDR_REG_PRESENT)
@ADDR_IOH                                                       // I2C Address Register
@ADDR_H
#endif

//-------------------------------------------------
// Prototypes of the I2CHW API.
//-------------------------------------------------
extern void  I2CHW_Start(void);		                                    //proxy class 1
extern void  I2CHW_DisableInt(void);		                               //proxy class 1
extern void  I2CHW_ResumeInt(void);                                  //proxy class 1
extern void  I2CHW_EnableInt(void);		                                //proxy class 1
extern void  I2CHW_ClearInt(void);		                                 //proxy class 1
extern void  I2CHW_Stop(void);		                                     //proxy class 1
#ifdef I2CHW_SLAVE_INCLUDE
extern void  I2CHW_EnableSlave(void);	                               //proxy class 1
extern void  I2CHW_DisableSlave(void);	                              //proxy class 1
#endif
#ifdef I2CHW_MSTR_INCLUDE
extern void  I2CHW_EnableMstr(void);		                               //proxy class 1
extern void  I2CHW_DisableMstr(void);	                               //proxy class 1
#endif
extern void  I2CHW_InitWrite(BYTE * pI2CHW_WriteBuf, BYTE  I2CHW_Write_Count);	//proxy class 1
extern void  I2CHW_InitRamRead(BYTE * pI2CHW_ReadBuf, BYTE  I2CHW_Read_Count);	//proxy class 1
extern void  I2CHW_InitFlashRead(const BYTE * pI2CHW_flashaddr,  unsigned int I2CHW_Read_CountHI);	   //proxy class 1
extern BYTE  I2CHW_bReadI2CStatus(void);	                            //proxy class 1
extern void  I2CHW_ClrRdStatus(void);	                               //proxy class 1
extern void  I2CHW_ClrWrStatus(void);	                               //proxy class 1


#define I2CHW_READ_BUFTYPE                   0x0

//I2CHW_SlaveStatus byte, Status Bit definitions
#define  I2CHW_RD_NOERR                      0x01     //read completed without errors
#define  I2CHW_RD_OVERFLOW                   0x02     //master read more bytes than were contained in read buffer
#define  I2CHW_RD_COMPLETE                   0x04     //last read transaction is complete
#define  I2CHW_READFLASH                     0x08     //set- next read will use flash read buffer, clear- next read will use ram read buffer
#define  I2CHW_WR_NOERR                      0x10     //write completed without errors
#define  I2CHW_WR_OVERFLOW                   0x20     //received bytes exceeded write buffer length
#define  I2CHW_WR_COMPLETE                   0x40     //indicates either a stop or new addr was rec'd after a write to slave.
#define  I2CHW_ISR_NEW_ADDR                  0x40     //New address received (can infer that previous transaction is complete)
#define  I2CHW_ISR_ACTIVE                    0x80     //ISR for I2C is active

// end of file I2CHW.h
