/*
  Aufgabenstellung:

  --Rundzellen: Mono, Baby, Mignon, Micro //alle vom Supermarkt gekauft
  --Entladung über konstanten Lastwiderstand //10 Ohm bisher gewählt, wird zur schnellen Entladung noch verkleinert
  --Beenden der Entladung bei 0,85 Volt
  --Excel Diagramm von Strom- und Spannungsverlauf //noch machen

  --LCD-Anzeige:
  --Insgesamt entnommene Ladungsmenge Q in mAh während der Entladung // I x t
  --Innenwiderstand am Anfang und am Ende der Entladung
  --Entladezeit in Sekunden und der bislang entnommene Ladungsmenge Q
  --Entladestrom und der Spannung der Batterie

*/



#include <LiquidCrystal_I2C.h> //Bibliothek
#include <Wire.h> //Bibliothek
LiquidCrystal_I2C lcd(0x3F, 2, 1, 0, 4, 5, 6, 7, 3, POSITIVE);  //I2C Adresse

//Batterietester
float Batterie; //Direkt gemessener Wert vom Analogpin
float Batteriespannung_Leerlauf; //Analogpin verrechnet
float Batterie_unter_Last;//Batterie belastet
float Wert_zur_Batterie;//Spannungs-Variable für die Messung, beginnt dann erst ab 0,0048V, schwankt dann nicht so extrem bis zum Einpendeln

int RelaisPin = 7; //Pin zum Schalten des Relais mit Pin7

float Widerstand = 10.00; //ohm
float Innenwiderstand; //Wert des Innenwiderstands der Batterie speichern
float Laststrom; //Laststrom, gleich wie Entladestrom
float Entladestrom; //Endladestrom, Variable wird verwendet um weiterzurechnen
float Ladungsmenge_Q_insgesamt; //Ladung Q gesamt in mAh
float Ladungsmenge_Q_bislang; //bislang entnommene Ladung Q in mAh
float Wert_unter_Last; //Leerlaufspannung der Batterie, entscheidet, ob Entladen wird oder nicht
float Wert_unter_Last_Anfang_RI; //Wert Innenwiderstand am Anfang der Entladung (größerer Strom) U=R*I
float Wert_unter_Last_Ende_RI; //Wert des Innenwiderstandes am Ende der Entladung (kleinerer Strom) U=R*I

float Faktor = 5.00 / 1024.00; // Für Spannung - 10Bit AD-Wandler im UNO 5V/1024 = 0,00488V pro Stufe Volt


float Startzeit; //Festhalten der abgelaufenen Zeit seit Start
float Aktuelle_Zeit; //Welche Zeit bis jetzt abgelaufen ist
float Laufzeit; //Ergebnis der Dauer der Entladung
float Entladezeit; //Entladezeit Dauer
float Entlade_Ende;


float Spannung_fuer_Excel; //LEERLAUFspannung für Excel



void setup()
{
  pinMode(RelaisPin, OUTPUT); // Relais an/abschalten
  digitalWrite(RelaisPin, HIGH);//Relais anziehen

  Serial.begin(115200); //Baudrate
  Serial.println("start");

  // LCD Begruessungsanzeige

  lcd.begin(20, 4); //Zeichen / Zeilen
  lcd.backlight();
  lcd.setCursor(0, 0); //Zeichen / Zeile
  lcd.print("Projekt");
  lcd.setCursor(0, 1);
  lcd.print("xxxxxx");
  lcd.setCursor(0, 2);
  lcd.print("Batterietester");
  lcd.setCursor(0, 3);
  lcd.print("xxxxxx");
  delay (2000);
  lcd.clear();
}



void Entladen() //Vorgang zum Entladen der Batterie

{

  //Als erstes Batterie in Leerlauf messen
  Serial.println("Messung beginnt");

  //Leerlaufspannung erfassen
  Batterie = analogRead(0); //PIN A0 einlesen
  Batteriespannung_Leerlauf = Batterie * Faktor; //Leerlaufspannung berechnen
  Serial.println(Batteriespannung_Leerlauf);



  //-------------------------zuschalten Last-------------------

  //Relais anziehen lassen, um die Last zuzuschalten
  digitalWrite(RelaisPin, HIGH); //Relais einschalten zum Entladen und um Spannung unter Last zu messen
  delay (250); //Viertel Sekunde warten, um sicherzugehen, dass das Relais angezogen hat

  Entladezeit = millis(); //Hält die Entladezeit fest, indem das Programm beginnt die Zeit ab diesem Zeitpunkt zu erfassen

  //unter Belastung und angezogenem Relais
  Batterie = analogRead(0); //Nochmal auslesen, weil vorher das Relais offen und die Batterie im Leerlauf war
  Batterie_unter_Last = Batterie * Faktor;//Batteriespannung unter Last berechnen


  //Laststrom
  Laststrom = Batterie_unter_Last / Widerstand; //Widerstand ganz oben festgelegt -10-Ohm



  //Innenwiderstand
  Innenwiderstand = ((Batteriespannung_Leerlauf - Batterie_unter_Last) / Laststrom); //Innenwiderstand berechnen


  //Innenwiderstand am Anfang und am Ende der Entladung
  //-Batterie voll und unter Last -> viel Strom, also bei geringer Batteriespannung wird der Strom kleiner, da Ri gleich-


  //Innenwiderstand -Ri- am Anfang der Entladung
  if (Wert_unter_Last_Anfang_RI > 1.40) //Batterieinnenwiderstand am Anfang der Entladung
  {
    Innenwiderstand = ((Batteriespannung_Leerlauf - Batterie_unter_Last) / Laststrom); //Innenwiderstand berechnen

    //Ri am vom ANFANG der Entladung auf Display schreiben
    lcd.setCursor(0, 0); //Zeichen / Zeile
    lcd.print("RiA="); //wird nicht angezeigt---------------
    lcd.print(Wert_unter_Last_Anfang_RI);
    // lcd.print("Ohm"); //Zeichen googlen
  }
  /*  else
    lcd.setCursor(1, 0); //Zeichen / Zeile
      lcd.print("RiA="); //wird nicht angezeigt---------------*/ //Test, Wenn Schaltung richtig, dann wird RiA auch angezeigt



  //Innenwiderstand -Ri- am ENDE der Entladung
  if (Wert_unter_Last_Ende_RI < 0.85) //Batterieinnenwiderstand am Ende der Entladung
  {
    Innenwiderstand = ((Batteriespannung_Leerlauf - Batterie_unter_Last) / Laststrom); //Innenwiderstand berechnen

    //Ri am Ende der Entladung auf Display schreiben
    lcd.setCursor(11, 0); //Zeichen / Zeile
    lcd.print("RiE=");
    lcd.print(Wert_unter_Last_Ende_RI);
    // lcd.print("Ohm");
  }



  //---Q ganz am Ende, da man hier erst weiß wieviel mAh verbraucht wurden

  //Entladezeit in Sekunden und der bislang entnommenen Ladungsmenge Q
  Ladungsmenge_Q_bislang = (Entladezeit * (Laststrom / 1000)); // :1000 für mA

  //Entladestrom und der Spannung der Batterie während des Entladevorgangs (siehe oben: Batterie_unter_Last);
  Entladestrom = Laststrom;

  //LCD Laststrom
  lcd.setCursor(0, 3); //Zeichen / Zeile
  lcd.print("IL=");
  lcd.print(Entladestrom);
  lcd.print("A"); //Ampere

  //LCD Batteriespannung unter Last
  lcd.setCursor(11, 3); //Zeichen / Zeile
  lcd.print("UL= ");
  lcd.print(Batterie_unter_Last); //Spannung der Batterie unter Last ausgeben
  lcd.print("V"); //Volt





  //Abschnitt Messungen-----------------------------
  //Mehr als 1 Messpunkt für Excel notwendig
  //Relais beginnt dann jede Sekunde zu schalten...

  Startzeit = millis(); //Zeit festhalten die seit Beginn des Programmstarts in der "Endlade-Messungen" vergangen ist

  for (int i = 0; i < 10; i++) //10 Messungen werden durchgeführt, wird immer um 1 erhöht bis i=10
  {
    Aktuelle_Zeit = millis(); //Liest die aktuelle Zeit aus
    Laufzeit = Aktuelle_Zeit - Startzeit; //Berechnung der Laufzeit einer Messung

    //Leerlauf schalten
    digitalWrite(RelaisPin, LOW); //Relaiskontakt öffnen für die Leerlaufspannung der Batterie

    Batteriespannung_Leerlauf = analogRead(0);
    Spannung_fuer_Excel = Batteriespannung_Leerlauf * Faktor; //Berechnung der Batteriespannung im Leerlauf für Excel

    /*Serial.println("Laufzeit: ");
      Serial.println(Laufzeit);
      Serial.print(" - ");  //Für Excel, damit man es besser in einer Tabelle darstellen kann
      Serial.println(Spannung_fuer_Excel);
      Serial.println("-----");
    */

    // ----------------Testen, ob das hier funktioniert----------------------------

    //Relais schliessen um Last wieder zuzuschalten
    digitalWrite(RelaisPin, HIGH);
    delay(250); //Relais Zeit zum Anziehen geben

    /*
      Serial.println("UL: ");
      Serial.print(Battere_unter_Last);
      Serial.println(" - ");

    */

    delay(250);// viertel Sekunde Pause bis es weitergeht mit der nächsten Messsung...1...2...3...4...5...6...7...8...9...10....1

  }


  Entlade_Ende = millis();
  //Insgesamt entnommene Ladungsmenge Q in Coulumb(C) in mAh während der Entladung
  //"Strom der in einer Sekunde bei 1A verschoben wird"
  Ladungsmenge_Q_insgesamt = ((Entlade_Ende - Entladezeit) * (Laststrom * 1000)); //1000 für mAh

  //LCD bislang entnommene Ladungsmenge
  lcd.setCursor(0, 1); //Zeichen / Zeile
  lcd.print("Qbsl=");
  lcd.print(Ladungsmenge_Q_bislang);
  lcd.print("mAh");

  //LCD Entladezeit
  lcd.setCursor(13, 1);
  lcd.print("t=");
  lcd.print(Entladezeit / 1000); //In sek auf dem Display ausgeben
  lcd.print("s");//sekunde

  //LCD Anzeige
  lcd.setCursor(0, 2); //Zeichen / Zeile
  lcd.print("QInsgesamt=");
  lcd.print(Ladungsmenge_Q_insgesamt); //Gesamte Ladungsmenge des Entladevorgangs ausgeben
  lcd.print("mAh");
}



void loop()

{
  //Zu Beginn schwankt die Messung ein wenig beim Anschluss auf Masse, festen Wert festlegen, um somit eine stabile Messung zu garantieren
  Wert_zur_Batterie = analogRead(0);

  if (Wert_zur_Batterie > 10) //Größer als (10=0,048V) damit wird die Messung stabilisiert, da mein Serieller Monitor immer extrem schwankt, wenn die Batterieleitung in der Luft ist
    //Rohwert gibt an auf welcher Spannungs-Stufe er steht...1024->5V    0->0V  Pro Bit-Stufe 0,00488V
    //Wird ganzzahlig eingelesen, da es nur ganzzahlige Bits beim DA-Wandler gibt

    //Schaltet erst in der "else if" schleife zur Funktion void Enlade()
    //Die Funktion wird aufgerufen, abgearbeitet und geschlossen

  {
    //Batterie ausschalten, Relais öffnet Laststromkreis
    digitalWrite(RelaisPin, LOW);
    delay(1000);//Kurze Verzögerung für mein Relais

    //Unter Last entstehende Spannung,
    Wert_unter_Last = Wert_zur_Batterie * Faktor; //Spannung unter Belastung




    if (Wert_unter_Last > 1.4) //in Volt
    {
      lcd.setCursor(5, 1); //Zeichen / Zeile
      lcd.print("Voll");
      Entladen(); //springt zu "void Entladen"
    }
    else if (Wert_unter_Last > 1.2) //in Volt
    {
      lcd.setCursor(5, 1); //Zeichen / Zeile
      lcd.print("Fast voll");
      Entladen(); //springt zu "void Entladen"
    }
    else if (Wert_unter_Last > 0.85)  //wenn größer als 0,85 wird entladen, wenn kleiner wird nicht mehr entladen
    {
      lcd.setCursor(5, 1); //Zeichen / Zeile
      lcd.print("Grenzwertig");
      Entladen(); //springt zu "void Entladen"
    }
    else if (Wert_unter_Last > 0.2) //in Volt
    {
      lcd.setCursor(5, 1); //Zeichen / Zeile
      lcd.print("LEER");
      delay(200);
      lcd.clear();
    }
    else //Bei kleiner als 0,2V ist keine Batterie angeschlossen
    {
      lcd.setCursor(5, 1); //Zeichen / Zeile
      lcd.print("Keine Batterie");
      Serial.print("keine");
      delay(200);
      lcd.clear();
    }
  }
}



