;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME:   LCD.inc
;;  Version: 1.60, Updated on 2011/6/28 at 6:9:34
;;  Generated by PSoC Designer 5.1.2306
;;
;;  DESCRIPTION:  Assembler declarations for the LCD user module interface.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2011. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************


; LCD connections to PSoC port
;
; PX.0 ==> LCD D4
; PX.1 ==> LCD D5
; PX.2 ==> LCD D6
; PX.3 ==> LCD D7
; PX.4 ==> LCD E
; PX.5 ==> LCD RS
; PX.6 ==> LCD R/W


include "m8c.inc"

;------------------------------------------------------
;  Register Address Constants for  LCD
;------------------------------------------------------

LCD_Port:                              equ   PRT2DR
LCD_PortMode0:                         equ   PRT2DM0
LCD_PortMode1:                         equ   PRT2DM1

LCD_BARGRAPH_ENABLE:                   equ   1


;-----------------------------------------------
;  Constants for LCD
;-----------------------------------------------
; LCD commands

LCD_DISP_ON:                      equ   0Ch
LCD_DISP_OFF:                     equ   08h
LCD_CURSOR_ON:                    equ   0Eh
LCD_CURSOR_OFF:                   equ   0Ch
LCD_CURSOR_BLINK:                 equ   0Fh
LCD_CURSOR_WINK:                  equ   0Dh
LCD_CURSOR_SH_LEFT:               equ   10h
LCD_CURSOR_SH_RIGHT:              equ   14h
LCD_CURSOR_HOME:                  equ   02h
LCD_CURSOR_LEFT:                  equ   04h
LCD_CURSOR_RIGHT:                 equ   06h
LCD_DISP_CLEAR_HOME:              equ   01h

LCD_SOLID_BG:                     equ   00h
LCD_LINE_BG:                      equ   01h

LCD_PORT_MASK:                    equ   7Fh

ICE_PORT_SYNC:     equ   0   ; This flag must be set to one to work around
                             ; the async read issue with the ICE with the 
                             ; 25/26xxx family of devices.  It will help
                             ; to eliminate "Invalid memory reference" errors.
                             ; It is not required when running without the ICE
							 ; or when using any other family besides the 
							 ; 25/26xxx family. If not using the ICE, this flag 
							 ; may be set to 0.

; end of file LCD.inc

