;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: Timer16.inc
;;   Version: 2.6, Updated on 2011/6/28 at 6:10:8
;;  Generated by PSoC Designer 5.1.2306
;;
;;  DESCRIPTION: Assembler declarations for the Timer16 user module interface
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2011. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for Timer16 API's.
;--------------------------------------------------

Timer16_CONTROL_REG_START_BIT:             equ 0x01    ; Control register start bit
Timer16_INT_REG:                           equ 0x0e1
Timer16_INT_MASK:                          equ 0x02


;--------------------------------------------------
; Constants for Timer16 user defined values
;--------------------------------------------------

Timer16_PERIOD:                            equ 0xffff
Timer16_COMPARE_VALUE:                     equ 0x0


;--------------------------------------------------
; Register Address Constants for Timer16
;--------------------------------------------------

Timer16_COUNTER_LSB_REG:               equ 0x20   ; DR0 Counter register
Timer16_COUNTER_MSB_REG:               equ 0x24
Timer16_PERIOD_LSB_REG:                equ 0x21   ; DR1 Period register
Timer16_PERIOD_MSB_REG:                equ 0x25
Timer16_COMPARE_LSB_REG:               equ 0x22   ; DR2 CompareValue register
Timer16_COMPARE_MSB_REG:               equ 0x26
Timer16_CONTROL_LSB_REG:               equ 0x23   ; Control register
Timer16_CONTROL_MSB_REG:               equ 0x27
Timer16_FUNC_LSB_REG:                  equ 0x20   ; Function register
Timer16_FUNC_MSB_REG:                  equ 0x24
Timer16_INPUT_LSB_REG:                 equ 0x21   ; Input register
Timer16_INPUT_MSB_REG:                 equ 0x25
Timer16_OUTPUT_LSB_REG:                equ 0x22   ; Output register
Timer16_OUTPUT_MSB_REG:                equ 0x26


;--------------------------------------------------
; Timer16 Macro 'Functions'
;--------------------------------------------------

   macro Timer16_Start_M
   or    reg[Timer16_CONTROL_LSB_REG],  Timer16_CONTROL_REG_START_BIT
   endm

   macro Timer16_Stop_M
   and   reg[Timer16_CONTROL_LSB_REG], ~Timer16_CONTROL_REG_START_BIT
   endm

   macro Timer16_EnableInt_M
   M8C_EnableIntMask Timer16_INT_REG, Timer16_INT_MASK
   endm

   macro Timer16_DisableInt_M
   M8C_DisableIntMask Timer16_INT_REG, Timer16_INT_MASK
   endm


; end of file Timer16.inc
